
plugin simpleManipulator arnoldlight_spotmanip
    name:~ARNOLD_LIGHT_SPOT_MANIP_NAME~
    invisible:true
(
    local greenColor =  colorMan.getColor #manipulatorsActive
    local redColor =    colorMan.getColor #manipulatorsSelected
	local offsetLength = 0.0

    on canManipulate target do
	(
		if not hasProperty target #shapeType then
		(
			return false
		)
		else
		(
			shapeType = target.shapeType
			if (shapeType != 2) then
			(
				return false
			)
			else
			(
				return (hasProperty target #cone_angle) and (hasProperty target #penumbra_angle) and (hasProperty target #targDist) and (hasProperty target #aspect_ratio)
			)
		)
	)

    on updateGizmos do
    (
        this.clearGizmos()
        
		local coneAngle = target.cone_angle
		local penumbraAngle = target.penumbra_angle
		local td = target.targDist
		local aspectRatio = target.aspect_ratio
		
		dConeAngle = tan(coneAngle*0.5) * td * 1.01
		dpenumbraAngle = tan((coneAngle-penumbraAngle)*0.5) * td * 1.01

		local giz1 = manip.makeGizmoShape()
		for i = 0 to 28 do
		(
			a = i * 360.0 / 28.0
			giz1.AddPoint([dConeAngle * sin(a), dConeAngle * cos(a) * aspectRatio, -1.0 * td])
		)
		this.addGizmoShape giz1 0 greenColor redColor 

		local giz2 = manip.makeGizmoShape()
		for i = 0 to 28 do
		(
			a = i * 360.0 / 28.0
			giz2.AddPoint([dpenumbraAngle * sin(a), dpenumbraAngle * cos(a) * aspectRatio, -1.0 * td])
		)
		this.addGizmoShape giz2 0 greenColor redColor 		
		
		-- aspect ratio
		local giz3 = manip.makeGizmoShape()
		giz3.AddPoint([0.0, 0.0, -1.0 * td])
		giz3.AddPoint([0.0, dConeAngle * aspectRatio, -1.0 * td])
		this.addGizmoShape giz3 0 greenColor redColor 			
		
        return node.name + " " + ~ARNOLD_LIGHT_SPOT_MANIP_CONE_ANGLE~ + " = " + target.cone_angle as string + ", " + ~ARNOLD_LIGHT_SPOT_MANIP_PENUMBRA_ANGLE~ + " = " + target.penumbra_angle as string + ", " + ~ARNOLD_LIGHT_SPOT_MANIP_ASPECT_RATIO~ + " = " + target.aspect_ratio as string 
    )

    on mouseMove m which do
    (
		local td = target.targDist
		local aspectRatio = target.aspect_ratio
        local pl = manip.makePlaneFromNormal z_axis [0, 0, -1.0 * td],
        projectedPoint = [0,0,0]
		
        viewRay = this.getLocalViewRay m

        res = pl.intersect viewRay &projectedPoint
    
        if (res) then
		(
			projectedPoint[3] = 0.0
			
			if which == 0 then 
			(	
			    -- factor in aspectRatio
				local localX = projectedPoint[1]
				local localY = projectedPoint[2] / aspectRatio
				local d = sqrt( localX*localX + localY*localY)
				local d = d / (1.01 * td)
				
				target.cone_angle = 2.0 * atan(d)
				return true
			)
			if which == 1 then
			(
				local coneAngle = target.cone_angle	

   		        -- factor in aspectRatio
				local localX = projectedPoint[1]
				local localY = projectedPoint[2] / aspectRatio
				local d = sqrt( localX*localX + localY*localY)
				local d = d / (1.01 * td)
				
				d = atan(d) * 2.0
				if (d > coneAngle) then (d = coneAngle)
				
				target.penumbra_angle = coneAngle - d
				return true
			)
			if which == 2 then
			(
				local coneAngle = target.cone_angle	
				dConeAngle = tan(coneAngle*0.5) * td * 1.01
				
				if offsetLength == 0.0 then 
					offsetLength = (target.aspect_ratio*dConeAngle) - (length projectedPoint)
				
				newConeDistance = ((length projectedPoint) + offsetLength) / 1.01
				newAspectRatio = newConeDistance / dConeAngle
				
				if(newAspectRatio > 1.0) then (newAspectRatio = 1.0)
				target.aspect_ratio = newAspectRatio
				
				return true
			)
		)

		-- if plane is perpendicular... do nothing (both angles are cocentrics)
    )
	
	on MouseDown m which do
	(
		offsetLength = 0.0
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBHyO6JdQbHWe1d3TDZdDYCAkMJoQlW4Ab2
-- 4DY/ughP3Bkw824B2FN/PZepjkxKxDk9NfvOpQyJKwwBedz2UXmjGeLN1PNSgpRy
-- Ps9IfBNIMrhWGmnmnO6IEV/rx/VH72kWqm05/SNmaQ1Y/QX1iskMDkYGdfFmgM0i
-- RyS6b87QC3TdI00kmMH+8XT2IV26Zd9RTcYg9XHzG1o8dzsFzsnCltuFWlwirDtY
-- RJm/jCxrswAyOBoPxKBDJbSH45Ckpk+UhSTnjcqryMRlN5DXzKNx8uKICZrBUxLC
-- 1ciwaA0N0J9MZFiJvIkufDTKm63csnkNkSSfIt9sVxc1zvXF++Ub
-- -----END-SIGNATURE-----